import pandas as pd  
import matplotlib.pyplot as plt  
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Calculate approval rates  
approval_rates_credit_history = credit_customers.groupby('credit_history')['class'].value_counts(normalize=True).unstack().fillna(0)['good']  
approval_rates_employment = credit_customers.groupby('employment')['class'].value_counts(normalize=True).unstack().fillna(0)['good']  
approval_rates_middle_age = credit_customers[(credit_customers['age'] > 40) & (credit_customers['age'] < 59)].groupby('age')['class'].value_counts(normalize=True).unstack().fillna(0)['good']  
credit_customers['credit_amount_range'] = pd.cut(credit_customers['credit_amount'], bins=[0, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000], include_lowest=True)  
approval_rates_credit_amount = credit_customers.groupby('credit_amount_range')['class'].value_counts(normalize=True).unstack().fillna(0)['good']  
  
# Plot bar charts  
fig, axes = plt.subplots(2, 2, figsize=(12, 8))  
  
approval_rates_credit_history.plot(kind='bar', ax=axes[0, 0], title='Approval Rates by Credit History')  
approval_rates_employment.plot(kind='bar', ax=axes[0, 1], title='Approval Rates by Employment Status')  
approval_rates_middle_age.plot(kind='bar', ax=axes[1, 0], title='Approval Rates for Middle-Age Group (40-59)')  
approval_rates_credit_amount.plot(kind='bar', ax=axes[1, 1], title='Approval Rates by Credit Amount Range')  
  
plt.tight_layout()  
plt.savefig('ref_result/bar_chart.png')
plt.show()  